<?php require_once 'config.php'; ?><!DOCTYPE html>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Rutas Del Sabor</title>
   <link rel="icon" href="CAPORAL/imagenes/Vaquiii.jpeg">
   <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; flex-direction: column; min-height: 100vh; background-color: #FFF8E1; color: #333; }
    header { background: linear-gradient(135deg,#ff6f86 0%, #ff94a2 50%, #ff6f86 100%); color: white; padding: 70px 20px; text-align: center; box-shadow: 0 6px 22px rgba(0,0,0,0.18); position:relative; overflow:hidden; }
    header h1{ font-family: 'Satisfy', cursive; font-size:56px; margin:0; letter-spacing:1px; text-shadow:0 6px 18px rgba(0,0,0,0.25); }
    header p{ margin:8px 0 0; font-size:18px; opacity:0.95 }
    .header-inner{ max-width:1200px; margin:0 auto; display:flex; flex-direction:column; align-items:center; justify-content:center; padding:8px 20px; }
    #user-area{ position:absolute; right:20px; top:18px; font-size: 14px; }
    #user-area a, #user-area button { color:white; text-decoration:none; font-weight:700; background: rgba(255,255,255,0.12); padding:8px 12px; border-radius:8px; border: none; cursor: pointer; font-family: 'Segoe UI', sans-serif; font-size: 14px; }
    #user-area span { margin-right: 10px; }
    .buscador { margin: 20px auto; text-align: center; }
    .buscador input { padding: 20px; width: 80%; max-width: 500px; font-size: 16px; border-radius: 5px; border: 1px solid #ccc; }
    .buscador input:focus { border-color: #D90429; outline: none; box-shadow: 0 0 0 3px rgba(217, 4, 41, 0.25); }
    main { padding: 20px; flex: 1; }
    .restaurantes { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; }
    .restaurante { background-color: #ffffff; border: 1px solid #ddd; border-radius: 10px; padding: 15px; text-align: center; box-shadow: 0 4px 6px rgba(0,0,0,0.1); transition: transform 0.2s, box-shadow 0.2s; }
    .restaurante h3 { color: #BF0426; }
    .restaurante:hover { transform: scale(1.02); box-shadow: 0 8px 12px rgba(0,0,0,0.15); }
    .restaurante a { display: inline-block; margin-top: 15px; padding: 10px 20px; background-color: #D90429; color: white; text-decoration: none; border-radius: 5px; font-weight: bold; transition: background-color 0.3s ease; }
    .restaurante img { width: 100%; height: 200px; object-fit: cover; border-radius: 8px; }
    .restaurante a:hover { background-color: #A8001E; }
    section { margin-top: 40px; }
    h2 { text-align: center; margin-bottom: 20px; color: #D90429; }
    footer { background-color: #ff94a2; color: #fff; text-align: center; padding: 20px; }
    #volverArribaBtn { display: none; position: fixed; bottom: 20px; right: 30px; z-index: 99; border: none; outline: none; background-color: #4E342E; color: white; cursor: pointer; padding: 15px; border-radius: 10px; font-size: 18px; text-decoration: none; }
    #volverArribaBtn:hover { background-color: #6D4C41; }
    @media (max-width: 768px) { header { padding: 30px 15px; } header h1 { font-size: 2.2rem; } header p { font-size: 0.9rem; } .buscador input { width: 90%; } #volverArribaBtn { right: 20px; bottom: 20px; padding: 12px; } }
    @media (max-width: 480px) { .restaurantes { grid-template-columns: 1fr; } }
  </style>
</head>
<body>

  <header>
    <div class="header-inner">
      <h1 style="margin:0">Rutas Del Sabor</h1>
      <p style="margin:8px 0 0">El camino más fácil para descubrir todos los restaurantes de nuestro municipio en un solo lugar</p>
    </div>
    <div id="user-area">
        <?php if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true): ?>
            <span>Hola, <strong><?php echo htmlspecialchars($_SESSION["username"]); ?></strong></span>
            <a href="logout.php">Cerrar sesión</a>
        <?php else: ?>
            <a href="login.php">Iniciar sesión</a>
        <?php endif; ?>
    </div>
    <svg width="100%" height="70" viewBox="0 0 100 20" preserveAspectRatio="none" style="position:absolute;left:0;bottom:0;"> 
      <path d="M0 20 C 20 0, 80 0, 100 20 L100 20 L0 20 Z" fill="rgba(255,255,255,0.08)"></path>
    </svg>
  </header>

  <div class="buscador">
    <input type="text" id="busqueda" placeholder="Buscar restaurante o comida..." onkeyup="filtrarRestaurantes()">
  </div>

  <?php if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true): ?>
  <div style="max-width:1200px;margin:14px auto;padding:14px;background:#fff7f8;border-radius:10px;border:1px solid rgba(217,4,41,0.08);display:flex;justify-content:space-between;align-items:center;gap:12px;">
    <div style="color:#333">
      <strong>¿Quieres dejar tu valoración?</strong>
      <div style="font-size:14px;color:#555">Inicia sesión o regístrate.</div>
    </div>
    <div style="display:flex;gap:8px;align-items:center">
      <a href="login.php" style="background:#D90429;color:white;padding:10px 14px;border-radius:8px;text-decoration:none;font-weight:700">Iniciar sesión</a>
      <a href="login.php?tab=register" style="background:transparent;border:2px solid #D90429;color:#D90429;padding:8px 12px;border-radius:8px;text-decoration:none;font-weight:700">Registrarse</a>
    </div>
  </div>
  <?php endif; ?>

  <main>
    <section class="restaurantes" id="listaRestaurantes">

      <div class="restaurante">
        <h3>Las Burguers</h3>
        <img src="Las Burguers/imagenes/frente2.jpeg">
        <p>Tu plan favoritos empieza aca en las Burguers</p>
        <p><a href="Las Burguers/Las Burguers.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Juancho Arepas</h3>
        <img src="Juancho Arepas/imagenes/afu1.jpg" alt="">
        <p>Arepas rellenas para los que no se conforman con poco</p>
        <p><a href="Juancho Arepas/Juancho Arepas.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Nare Gastro-Bar</h3>
        <img src="Nare/imagenes/aden4.jpg" alt="Veggie Life">
        <p>De lo tradicional a lo especial en Nare siempre hay una opción para ti</p>
        <p><a href="Nare/Nare.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Caporal</h3>
        <img src="CAPORAL/imagenes/afu1.jpeg" alt="Veggie Life">
        <p>Donde el sabor es grande, y las ganas de volver, aún más.</p>
        <p><a href="CAPORAL/Caporal.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Tropick</h3>
        <img src="Tropik/imagenes/afu.jpeg" alt="Veggie Life">
        <p>Más que comida, una experiencia de sabor</p>
        <p><a href="Tropik/Tropik.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>La Roca</h3>
        <img src="La Roca/imagenes/afu3.jpeg" alt="Veggie Life">
        <p>Sabor que derrite mas que el queso</p>
        <p><a href="La Roca/La Roca.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>La Frida</h3>
        <img src="Frida/imagenes/afu2.jpg" alt="Veggie Life">
        <p>Autentico sabor que enamora</p>
        <p><a href="Frida/Frida.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>La Tentación</h3>
        <img src="Tentacion/imagenes/afu1.jpg" alt="Veggie Life">
        <p>Date el gusto de caer en la tentación</p>
        <p><a href="Tentacion/La Tentación.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>charlotte</h3>
        <img src="charlotte/imagenes/afu 1.jpg" alt="Veggie Life">
        <p>El arte del churro y el aroma del cafe</p>
        <p><a href="charlotte/charlotte.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Carbonero</h3>
        <img src="Carbonero/imagenes/afu1.jpg" alt="Veggie Life">
        <p>Donde el fuego le da vida al sabor</p>
        <p><a href="Carbonero/Carbonero.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Montecarlo</h3>
        <img src="Montecarlo/imagenes/afu1.jpg" alt="Veggie Life">
        <p>El rincon donde el cafe se encuentra con el antojo </p>
        <p><a href="Montecarlo/Montecarlo.php">Mas información</a></p>
      </div>

      <div class="restaurante">
        <h3>Nativos</h3>
        <img src="Nativos/imagenes/afu1.jpg" alt="Veggie Life">
        <p>Alimenta tu cuerpo, disfruta tu alma </p>
        <p><a href="Nativos/Nativos.php">Mas información</a></p>
      </div>
    </section>
  </main>

  <a href="#" id="volverArribaBtn" title="Volver Arriba">↑</a>

  <footer >
    <p>&copy; 2025 Rutas Del Sabor. Todos los derechos reservados.</p>
  </footer>

  <script>
    function filtrarRestaurantes() {
      const input = document.getElementById("busqueda").value.toLowerCase();
      const restaurantes = document.querySelectorAll(".restaurante");

      restaurantes.forEach(function (restaurante) {
        const texto = restaurante.textContent.toLowerCase();
        restaurante.style.display = texto.includes(input) ? "block" : "none";
      });
    }
 
    const volverArribaBtn = document.getElementById("volverArribaBtn");
    window.onscroll = function() {
      if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
        volverArribaBtn.style.display = "block";
      } else {
        volverArribaBtn.style.display = "none";
      }
    };
    volverArribaBtn.onclick = function(e) {
      e.preventDefault();
      window.scrollTo({top: 0, behavior: 'smooth'});
    }
  </script>

</body>
</html>
