<?php
// Incluir configuración de la BD y sesión
require_once '../config.php';

// Identificador único de este restaurante
$nombre_restaurante = 'Nare';

// --- OBTENER CALIFICACIONES EXISTENTES ---
$calificaciones = [];
$promedio = 0;
$total_calificaciones = 0;

// Prepara la consulta para obtener calificaciones y nombres de usuario
$sql = "SELECT c.calificacion, c.comentario, c.fecha, u.nombre_usuario 
        FROM calificaciones c 
        JOIN usuarios u ON c.id_usuario = u.id 
        WHERE c.nombre_restaurante = ? 
        ORDER BY c.fecha DESC";

if ($stmt = $conn->prepare($sql)) {
    $stmt->bind_param("s", $nombre_restaurante);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $total_calificaciones = $resultado->num_rows;
    $suma_calificaciones = 0;

    if ($total_calificaciones > 0) {
        while ($fila = $resultado->fetch_assoc()) {
            $calificaciones[] = $fila;
            $suma_calificaciones += $fila['calificacion'];
        }
        $promedio = round($suma_calificaciones / $total_calificaciones, 1);
    }
    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nare - Rutas Del Sabor</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="icon" href="imagenes/Vaquiii.jpeg">
    <style>
        /* --- ESTILOS PARA SECCIÓN DE CALIFICACIONES -- */
        .ratings-section { background-color: #fff8e1; padding: 40px 20px; text-align: center; }
        .ratings-summary { margin-bottom: 30px; }
        .ratings-summary h2 { color: #BF0426; margin-bottom: 10px; }
        .star-rating-display { font-size: 2.5rem; color: #ffc107; }
        .star-rating-display .far { color: #e4e5e9; }
        .ratings-summary p { color: #555; font-weight: bold; }
        .rating-form-container, .ratings-list { max-width: 700px; margin: 0 auto; text-align: left; background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
        .rating-form-container h3, .ratings-list h3 { color: #BF0426; margin-bottom: 20px; }
        .rating-form .rate { display: flex; flex-direction: row-reverse; justify-content: center; margin-bottom: 15px; }
        .rating-form .rate > input { display:none; }
        .rating-form .rate > label { font-size: 2.5rem; color: #e4e5e9; cursor: pointer; transition: color 0.2s; }
        .rating-form .rate > input:checked ~ label, .rating-form .rate:not(:checked) > label:hover, .rating-form .rate:not(:checked) > label:hover ~ label { color: #ffc107; }
        .rating-form textarea { width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd; min-height: 80px; margin-bottom: 15px;}
        .rating-form button { background-color: #D90429; color: white; padding: 12px 20px; border: none; border-radius: 5px; cursor: pointer; font-weight: bold;}
        .login-prompt { text-align: center; padding: 20px; background: #fff6f6; border: 1px solid #ffdede; border-radius: 8px; }
        .ratings-list .comment { border-bottom: 1px solid #eee; padding: 15px 0; }
        .ratings-list .comment:last-child { border-bottom: none; }
        .comment-header { display: flex; align-items: center; margin-bottom: 5px; }
        .comment-header strong { font-size: 1.1em; color: #333; margin-right: 10px; }
        .comment-stars { color: #ffc107; }
        .comment-stars .far { color: #e4e5e9; }
        .comment-date { font-size: 0.8em; color: #999; margin-left: auto; }
        .comment p { margin: 0; color: #555; }
        .form-message { padding: 12px; border-radius: 8px; margin-bottom: 15px; font-weight: 500; text-align: center; }
        .form-message.error { color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb; }
        .form-message.success { color: #155724; background-color: #d4edda; border: 1px solid #c3e6cb; }
    </style>
</head>
<body>
<header class="header">
    <div class="menu container">
        <img src="imagenes/Vaquiii.jpeg" alt="logo" style="width: 130px; height:auto;">
        <input type="checkbox" id="menu"/>
        <label for="menu"><img src="imagenes/menu.png" class="menu-icono" alt="menu"></label>
        <nav class="navbar">
            <ul>
                <li><a href="../index.php">inicio</a></li>
                <li><a href="https://maps.app.goo.gl/dzbcjWbmCJE3N58V6">Ubicación</a></li>
                <li><a href="menu.html">Menú</a></li>
                <?php if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true): ?>
                    <li><a href="../logout.php">Cerrar Sesión</a></li>
                <?php else: ?>
                    <li><a href="../login.php">Iniciar Sesión</a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
    <div class="header-content container">
        <div class="header-txt">
            <h1>Nare </h1>
            <p>Gastro-Bar</p>
        </div>
    </div>
</header>

<section class="ratings-section">
    <div class="container">
        <div class="ratings-summary">
            <h2>Calificaciones</h2>
            <div class="star-rating-display">
                <?php
                if ($total_calificaciones > 0) {
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $promedio) echo '<i class="fas fa-star"></i>';
                        elseif ($i - 0.5 <= $promedio) echo '<i class="fas fa-star-half-alt"></i>';
                        else echo '<i class="far fa-star"></i>';
                    }
                } else {
                    for ($i = 0; $i < 5; $i++) echo '<i class="far fa-star"></i>';
                }
                ?>
            </div>
            <p><?php echo htmlspecialchars($promedio); ?> de 5 estrellas (<?php echo $total_calificaciones; ?> valoraciones)</p>
        </div>
        <div class="rating-form-container">
            <?php 
            if (isset($_GET['error'])) echo '<div class="form-message error">' . htmlspecialchars($_GET['error']) . '</div>';
            if (isset($_GET['exito'])) echo '<div class="form-message success">' . htmlspecialchars($_GET['exito']) . '</div>';
            if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true): ?>
                <h3>Deja tu valoración</h3>
                <form class="rating-form" action="../procesar_calificacion.php" method="POST">
                    <div class="rate">
                        <input type="radio" id="star5" name="calificacion" value="5" /><label for="star5">&#9733;</label>
                        <input type="radio" id="star4" name="calificacion" value="4" /><label for="star4">&#9733;</label>
                        <input type="radio" id="star3" name="calificacion" value="3" /><label for="star3">&#9733;</label>
                        <input type="radio" id="star2" name="calificacion" value="2" /><label for="star2">&#9733;</label>
                        <input type="radio" id="star1" name="calificacion" value="1" /><label for="star1">&#9733;</label>
                    </div>
                    <textarea name="comentario" placeholder="Escribe tu opinión sobre el lugar..."></textarea>
                    <input type="hidden" name="nombre_restaurante" value="<?php echo $nombre_restaurante; ?>">
                    <input type="hidden" name="redirect_url" value="Nare/Nare.php">
                    <button type="submit">Enviar Calificación</button>
                </form>
            <?php else: ?>
                <div class="login-prompt"><p>Debes <a href="../login.php"><b>iniciar sesión</b></a> para dejar una calificación.</p></div>
            <?php endif; ?>
        </div>
        <?php if (!empty($calificaciones)): ?>
        <div class="ratings-list">
            <h3>Opiniones de otros clientes</h3>
            <?php foreach ($calificaciones as $calificacion): ?>
            <div class="comment">
                <div class="comment-header">
                    <strong><?php echo htmlspecialchars($calificacion['nombre_usuario']); ?></strong>
                    <div class="comment-stars">
                        <?php for($i = 0; $i < 5; $i++) { echo $i < $calificacion['calificacion'] ? '<i class="fas fa-star"></i>' : '<i class="far fa-star"></i>'; } ?>
                    </div>
                    <span class="comment-date"><?php echo date("d/m/Y", strtotime($calificacion['fecha'])); ?></span>
                </div>
                <p><?php echo nl2br(htmlspecialchars($calificacion['comentario'])); ?></p>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<section class="information container">
    <div class="information-content">
        <div class="info-card-alt">
            <div class="info-card-alt-img"><img src="imagenes/aden4.jpg" alt="Interior del restaurante"></div>
            <div class="info-card-alt-text">
                <h3>Redes Sociales</h3>
                <p>¿Quieres estar actualizado con el contenido de este restaurante? Aquí encontrarás más información.</p>
                <div class="social-icons">
                    <a href="https://www.instagram.com/naregastrobar/?__pwa=1" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" target="_blank" title="Facebook"><i class="fab fa-facebook"></i></a>
                    <a href="#" target="_blank" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                </div>
            </div>
        </div>
        <div class="info-card-alt">
            <div class="info-card-alt-img"><img src="imagenes/afu1.jpg" alt="Fachada del restaurante"></div>
            <div class="info-card-alt-text">
                <h3>¡Bienvenidos!</h3>
                <p>En Nare creemos que cada comida es una oportunidad para disfrutas, compartir y recargar energía, Cocinamos con amor y ese toque casero que te hace sentir como en casa.</p>
            </div>
        </div>
    </div>
</section>

<section class="gallery container">
    <h2>Especialidades</h2>
    <div class="gallery-content">
        <div class="gallery-item"><img src="imagenes/comida1.jpg" alt="Creamy Salmon"><h3>Creamy Salmon</h3></div>
        <div class="gallery-item"><img src="imagenes/comida2.jpg" alt="Cordon Bleu"><h3>Cordon Bleu</h3></div>
        <div class="gallery-item"><img src="imagenes/comida3.jpg" alt="Desayunos"><h3>Desayunos</h3></div>
    </div>
</section>
<a href="#" id="volverArribaBtn" title="Volver Arriba">↑</a>
<footer>
    <p>&copy; 2025 Rutas Del Sabor. Todos los derechos reservados.</p>
</footer>

<script>
    const volverArribaBtn = document.getElementById("volverArribaBtn");
    window.onscroll = function() {
      if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
        volverArribaBtn.style.display = "block";
      } else {
        volverArribaBtn.style.display = "none";
      }
    };
    volverArribaBtn.onclick = function(e) {
      e.preventDefault();
      window.scrollTo({top: 0, behavior: 'smooth'});
    };
</script>
</body>
</html>
