<?php
// Incluye la configuración de la base de datos y la lógica de sesión.
require_once "config.php";

// --- LÓGICA DE LOGIN ---
$identifier = $password = "";
$login_err = "";

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['login-submit'])) {

    // Valida que el identificador y la contraseña no estén vacíos.
    if (empty(trim($_POST["identifier"]))) {
        $login_err = "Por favor, ingresa tu correo o nombre de usuario.";
    } else {
        $identifier = trim($_POST["identifier"]);
    }

    if (empty(trim($_POST["password"]))) {
        $login_err = "Por favor, ingresa tu contraseña.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Si no hay errores, verifica las credenciales.
    if (empty($login_err)) {
        $sql = "SELECT id, nombre_usuario, email, password FROM usuarios WHERE nombre_usuario = ? OR email = ?";
        
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("ss", $identifier, $identifier);
            
            if ($stmt->execute()) {
                $stmt->store_result();
                
                if ($stmt->num_rows == 1) {
                    $stmt->bind_result($id, $username, $email, $hashed_password);
                    if ($stmt->fetch()) {
                        if (password_verify($password, $hashed_password)) {
                            // Contraseña correcta, inicia sesión.
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["username"] = $username;
                            
                            // Redirige a la página principal.
                            header("location: Index.php");
                            exit;
                        } else {
                            $login_err = "Usuario o contraseña incorrectos.";
                        }
                    }
                } else {
                    $login_err = "Usuario o contraseña incorrectos.";
                }
            } else {
                $login_err = "¡Ups! Algo salió mal. Inténtalo de nuevo.";
            }
            $stmt->close();
        }
    }
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login - Rutas Del Sabor</title>
  <link rel="icon" href="CAPORAL/imagenes/Vaquiii.jpeg">
  <style>
    :root{
      --crema: #FFF8E1; --rosa-claro: #ff94a2; --rojo: #D90429; --rojo-oscuro: #A8001E;
      --titulo: #BF0426; --texto:#333;
    }
    *{box-sizing:border-box}
    body{
      margin:0; font-family: 'Segoe UI', sans-serif; background: linear-gradient(180deg,var(--crema) 0%, #fff 60%);
      color:var(--texto); min-height:100vh; display:flex; align-items:center; justify-content:center; padding:20px;
    }
    .card{
      width:100%; max-width:900px; display:grid; grid-template-columns:1fr 1fr; gap:0;
      border-radius:12px; overflow:hidden; box-shadow:0 8px 30px rgba(0,0,0,0.12); background:#fff;
    }
    .hero{
      background: linear-gradient(135deg,var(--rosa-claro), var(--rojo)); color:white; padding:40px;
      display:flex; flex-direction:column; justify-content:center; align-items:center; text-align:center;
    }
    .hero h1{font-family: 'Satisfy', cursive; margin:0 0 10px; font-size:40px}
    .hero p{margin:0 0 20px; max-width:320px}
    .hero a{background:rgba(255,255,255,0.18); padding:10px 16px; border-radius:8px; color:white; text-decoration:none; font-weight:600}
    .form-area{padding:36px}
    .tabs{display:flex; gap:8px; margin-bottom:18px}
    .tab{flex:1; text-align:center; padding:10px; border-radius:8px; cursor:pointer; background:#f6f6f6; color:var(--titulo); font-weight:700}
    .tab.active{background:var(--rosa-claro); color:#fff}
    form{display:grid; gap:12px}
    label{font-size:14px}
    input[type="text"], input[type="email"], input[type="password"]{
      width:100%; padding:12px 14px; border-radius:8px; border:1px solid #ddd; font-size:14px
    }
    .actions{display:flex; gap:10px; align-items:center}
    .btn{padding:12px 16px; border-radius:8px; border:none; cursor:pointer; font-weight:700}
    .btn-primary{background:var(--rojo); color:#fff}
    .btn-ghost{background:transparent; border:2px solid var(--rosa-claro); color:var(--rosa-claro)}
    .note{font-size:13px; color:#666}
    .error, .success{ padding:12px; border-radius:8px; margin-bottom:15px; font-weight:500; }
    .error{ color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb; }
    .success{ color: #155724; background-color: #d4edda; border: 1px solid #c3e6cb; }
    footer{margin-top:18px; text-align:center}
    @media (max-width:800px){
      .card{grid-template-columns:1fr}
      .hero{padding:24px}
      .hero h1{font-size:32px}
    }
  </style>
</head>
<body>

  <div class="card">
    <div class="hero">
      <h1>Rutas Del Sabor</h1>
      <p>Accede para valorar los restaurantes. Si no tienes cuenta, regístrate.</p>
      <a href="Index.php">Volver al inicio</a>
    </div>

    <div class="form-area">
      <div class="tabs">
        <div id="tab-login" class="tab active">Iniciar sesión</div>
        <div id="tab-register" class="tab">Registrarse</div>
      </div>

      <div id="msg" aria-live="polite">
        <?php 
        // Muestra mensajes de error/éxito desde la URL
        if (!empty($login_err)) {
            echo '<div class="error">' . htmlspecialchars($login_err) . '</div>';
        }
        if (isset($_GET['error'])) {
            echo '<div class="error">' . htmlspecialchars($_GET['error']) . '</div>';
        }
        if (isset($_GET['exito'])) {
            echo '<div class="success">' . htmlspecialchars($_GET['exito']) . '</div>';
        }
        ?>
      </div>

      <!-- FORMULARIO DE LOGIN -->
      <form id="login-form" action="login.php" method="POST">
        <div>
          <label for="login-email">Correo o usuario</label>
          <input id="login-email" name="identifier" type="text" placeholder="correo@ejemplo.com o usuario" required>
        </div>
        <div>
          <label for="login-password">Contraseña</label>
          <input id="login-password" name="password" type="password" placeholder="Contraseña" required>
        </div>
        <div class="actions">
          <button type="submit" name="login-submit" class="btn btn-primary">Entrar</button>
          <button type="button" id="show-register" class="btn btn-ghost">Crear cuenta</button>
        </div>
      </form>

      <!-- FORMULARIO DE REGISTRO -->
      <form id="register-form" action="procesar_registro.php" method="POST" style="display:none">
        <div>
          <label for="reg-user">Usuario</label>
          <input id="reg-user" name="usuario" type="text" placeholder="usuario" required>
        </div>
        <div>
          <label for="reg-email">Correo electrónico</label>
          <input id="reg-email" name="email" type="email" placeholder="correo@ejemplo.com" required>
        </div>
        <div>
          <label for="reg-password">Contraseña</label>
          <input id="reg-password" name="password" type="password" placeholder="Mínimo 6 caracteres" required>
        </div>
        <div>
          <label for="reg-confirm-password">Confirmar Contraseña</label>
          <input id="reg-confirm-password" name="confirm_password" type="password" placeholder="Repite la contraseña" required>
        </div>
        <div class="actions">
          <button type="submit" class="btn btn-primary">Registrar</button>
          <button type="button" id="show-login" class="btn btn-ghost">Volver a entrar</button>
        </div>
      </form>

      <footer>
        <small>&copy; 2025 Rutas Del Sabor</small>
      </footer>
    </div>
  </div>

  <script>
    // Elementos
    const tabLogin = document.getElementById('tab-login');
    const tabRegister = document.getElementById('tab-register');
    const loginForm = document.getElementById('login-form');
    const registerForm = document.getElementById('register-form');
    const showRegisterBtn = document.getElementById('show-register');
    const showLoginBtn = document.getElementById('show-login');

    // Función para cambiar entre pestañas
    function switchTo(tab) {
      if (tab === 'login') {
        tabLogin.classList.add('active');
        tabRegister.classList.remove('active');
        loginForm.style.display = '';
        registerForm.style.display = 'none';
      } else {
        tabRegister.classList.add('active');
        tabLogin.classList.remove('active');
        loginForm.style.display = 'none';
        registerForm.style.display = '';
      }
    }

    // Event Listeners para los botones y pestañas
    tabLogin.addEventListener('click', () => switchTo('login'));
    tabRegister.addEventListener('click', () => switchTo('register'));
    showRegisterBtn.addEventListener('click', () => switchTo('register'));
    showLoginBtn.addEventListener('click', () => switchTo('login'));

    // Si la URL tiene ?tab=register, muestra el formulario de registro
    (function() {
      const params = new URLSearchParams(window.location.search);
      if (params.get('tab') === 'register' || <?php echo isset($_POST['usuario']) ? 'true' : 'false'; ?>) {
        switchTo('register');
      }
    })();
  </script>

</body>
</html>